/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemTerminalBlock
extends BaseEntityBlock {
    public ItemTerminalBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f).m_60918_(SoundType.f_56742_));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)worldIn, pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        String reason = tile.getInvalidTerminalReason();
        if (reason != null) {
            if (!worldIn.f_46443_) {
                player.m_6352_((Component)new TranslatableComponent(reason).m_130940_(ChatFormatting.RED), UUID.randomUUID());
            }
            return InteractionResult.SUCCESS;
        }
        if (!worldIn.f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)tile, (BlockPos)pos);
            tile.updateItems(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)worldIn, pos);
            if (tile != null) {
                Utility.dropInventory(tile, (IItemHandler)tile.items);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ItemTerminalBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Utility.addTooltip(this.getRegistryName().m_135815_(), tooltip);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BaseEntityBlock.m_152132_(type, Registry.itemTerminalBlockEntity, ItemTerminalBlockEntity::tick);
    }
}

